package gov.va.med.mhv.mrp.web.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.RequestScoped;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.web.bean.UserProfile;
import gov.va.med.mhv.mrp.web.converter.MyGoalListConverter;
import gov.va.med.mhv.mrp.web.model.MyGoal;
import gov.va.med.mhv.mrp.web.model.MyGoals;
import gov.va.med.mhv.mrp.web.util.MyGoalsCategoryCompare;
import gov.va.med.mhv.mrp.webservice.MyGoalsWebService;

@ManagedBean
@RequestScoped
public class TrackGoalsController implements Serializable {
	private static final long serialVersionUID = 1L;
	private static Logger log = LogManager.getLogger(TrackGoalsController.class);

	@ManagedProperty("#{myGoalsWebServiceProxy}")
	private MyGoalsWebService myGoalsWebServiceProxy;

	@ManagedProperty("#{myGoalListConverter}")
	private MyGoalListConverter myGoalListConverter;

	@ManagedProperty("#{userProfile}")
	private UserProfile userProfile;

	private MyGoals myGoals = new MyGoals();

	private List<String> categories = new ArrayList<String>();

	private List<String> selectedCategories;
	
	private List<String> filteredCategories = new ArrayList<String>();

	@PostConstruct
	public void init() {
		log.debug("@PostConstruct");

		log.debug("userProfileId=" + userProfile.getUserProfileId());

		if (userProfile.getUserProfileId() != null) {
			List<MyGoalDTO> dtoList = myGoalsWebServiceProxy.getMyGoalsForUser(userProfile.getUserProfileId());

			if (log.isDebugEnabled()) {
				log.debug("dtoList size=" + (dtoList.isEmpty() ? 0 : dtoList.size()));
			}

			List<MyGoal> goalList = myGoalListConverter.convert(dtoList);

			if (log.isDebugEnabled()) {
				log.debug("goalList size=" + (goalList.isEmpty() ? 0 : goalList.size()));
			}

			myGoals.setGoals(goalList);

			List<String> list = new ArrayList<String>();

			for (MyGoal goal : myGoals.getGoals()) {
				list.add(goal.getCategory());
			}

			categories = new ArrayList<String>(new HashSet<String>(list));

			Collections.sort(categories);

			categories.add("View All");
		}

	}

	public String filterByCategory() {

		if (!selectedCategories.isEmpty()) {
			List<MyGoal> goalCategoryList = new ArrayList<MyGoal>();
			List<String> list = new ArrayList<String>();
			boolean viewAll = selectedCategories.contains("View All");
			
			for (MyGoal goal : myGoals.getGoals()) {
				if (viewAll || selectedCategories.contains(goal.getCategory())) {
					goalCategoryList.add(goal);
					list.add(goal.getCategory());
				}
			}

			filteredCategories = new ArrayList<String>(new HashSet<String>(list));
			
			Collections.sort(filteredCategories);
			
			myGoals.setFilters(goalCategoryList);
		}
		
		return "summary";
	}

	public List<String> getCategories() {
		return categories;
	}

	public List<String> getFilteredCategories() {
		return filteredCategories;
	}
	
	public MyGoals getMyGoals() {
		return myGoals;
	}

	public void setMyGoalsWebServiceProxy(MyGoalsWebService myGoalsWebServiceProxy) {
		this.myGoalsWebServiceProxy = myGoalsWebServiceProxy;
	}

	public void setMyGoalListConverter(MyGoalListConverter myGoalListConverter) {
		this.myGoalListConverter = myGoalListConverter;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}

	public List<String> getSelectedCategories() {
		return selectedCategories;
	}

	public void setSelectedCategories(List<String> selectedCategories) {
		this.selectedCategories = selectedCategories;
	}
}
